/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.util.flowerset;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;

public class FlowerSet<T>
implements Set<T> {
    final int petals;
    final Function<FlowerNode, Integer> comparerison;

    public FlowerSet(int petals, Function<FlowerNode, Integer> comparerison) {
        this.petals = petals;
        this.comparerison = comparerison;
    }

    public static FlowerSet createBase64(Function<FlowerNode, Integer> comparerison) {
        return new FlowerSet(64, comparerison);
    }

    public static FlowerSet createHexflower(Function<FlowerNode, Integer> comparerison) {
        return new FlowerSet(16, comparerison);
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return null;
    }

    @Override
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return null;
    }

    @Override
    public boolean add(T t) {
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
    }

    static class Functions {
        Functions() {
        }

        public static Function<FlowerNode, Integer> HashBasedFunction() {
            return function -> function.hashCode() % ((FlowerNode)function).map.petals;
        }
    }

    static class FlowerNode<V> {
        private final FlowerSet<V> map;
        final V value;
        final FlowerNode[] links;
        private static final int DEPTH = 20480;

        public FlowerNode(V value, FlowerSet<V> map) {
            this.value = value;
            this.map = map;
            this.links = new FlowerNode[map.petals];
        }

        public void TryToSetSingleNode(FlowerNode node, FlowerNode toset, int place, int depth) {
            if (depth > 20480) {
                throw new IllegalStateException("Recursive Call went too deep.");
            }
            if (node.links[place] == null) {
                node.links[place] = toset;
            } else {
                this.TryToSetSingleNode(node.links[place], toset, place, depth++);
            }
        }

        public void TryToSetSingleNode(FlowerNode node, FlowerNode toset, int place) {
            if (node.links[place] == null) {
                node.links[place] = toset;
            } else {
                this.TryToSetSingleNode(node.links[place], toset, place, 0);
            }
        }

        @SafeVarargs
        public final void SetUpLinks(FlowerNode<V> ... links) {
            for (FlowerNode<V> node : links) {
                int place = this.map.comparerison.apply(node);
                this.TryToSetSingleNode(this, node, place);
            }
        }
    }
}

